/*:
 * @author Julbob
 * @plugindesc Triggers a Common Event when any actor changes equipment.
 * @target MZ
 *
 * @param commonEventId
 * @text Common Event ID
 * @desc The ID of the Common Event that will be called when equipment changes.
 * @type common_event
 * @default 1
 *
 * @help
 * This plugin triggers a common event whenever any actor in the game changes
 * their equipment. The ID of the common event is specified through the
 * "Common Event ID" parameter in the plugin settings.
 */

(function () {
  var parameters = PluginManager.parameters("CommonEventOnEquipmentChange");
  var commonEventId = parameters["commonEventId"] || "1";

  Object.defineProperty(Game_Actor.prototype, "oldEquipsStates", {
    get: function () {
      return (
        this._oldEquipsStates ||
        (this._oldEquipsStates = this.equips().map((item) =>
          item ? item.id : 0
        ))
      );
    },
    set: function (value) {
      this._oldEquipsStates = value;
    },
    configurable: true,
  });

  var reserveCommonEventNextUpdate = false;

  var _Game_Actor_refresh = Game_Actor.prototype.refresh;

  Game_Actor.prototype.refresh = function () {
    _Game_Actor_refresh.call(this);

    const newEquipStates = this.equips().map((item) => (item ? item.id : 0));

    if (!this.oldEquipsStates.every((id, i) => id === newEquipStates[i])) {
      this.oldEquipsStates = newEquipStates;
      reserveCommonEventNextUpdate = true;
    }
  };

  var _Scene_Map_update = Scene_Map.prototype.update;

  Scene_Map.prototype.update = function () {
    _Scene_Map_update.call(this);

    if (reserveCommonEventNextUpdate) {
      $gameTemp.reserveCommonEvent(Number(commonEventId));
      reserveCommonEventNextUpdate = false;
    }
  };
})();
